$NetBSD: patch-fixincludes_fixincl.x,v 1.2 2015/11/03 13:59:10 jperkin Exp $

Fix for El Capitan / Xcode 7 from https://trac.macports.org/ticket/48471

--- fixincludes/fixincl.x.orig	2014-12-13 17:47:30.000000000 +0000
+++ fixincludes/fixincl.x
@@ -1,12 +1,12 @@
 /*  -*- buffer-read-only: t -*- vi: set ro:
- * 
+ *
  * DO NOT EDIT THIS FILE   (fixincl.x)
- * 
- * It has been AutoGen-ed  December 13, 2014 at 05:31:32 AM by AutoGen 5.12
+ *
+ * It has been AutoGen-ed
  * From the definitions    inclhack.def
  * and the template file   fixincl
  */
-/* DO NOT SVN-MERGE THIS FILE, EITHER Sat Dec 13 05:31:32 PST 2014
+/* DO NOT SVN-MERGE THIS FILE, EITHER Fri Oct  9 05:27:32 CEST 2015
  *
  * You must regenerate it.  Use the ./genfixes script.
  *
@@ -15,7 +15,7 @@
  * certain ANSI-incompatible system header files which are fixed to work
  * correctly with ANSI C and placed in a directory that GNU C will search.
  *
- * This file contains 227 fixup descriptions.
+ * This file contains 232 fixup descriptions.
  *
  * See README for more information.
  *
@@ -2092,6 +2092,221 @@ static const char* apzCdef_CplusplusPatc
 
 /* * * * * * * * * * * * * * * * * * * * * * * * * *
  *
+ *  Description of Clang_Macro___Has_Builtin fix
+ */
+tSCC zClang_Macro___Has_BuiltinName[] =
+     "clang_macro___has_builtin";
+
+/*
+ *  File name selection pattern
+ */
+#define zClang_Macro___Has_BuiltinList (char*)NULL
+/*
+ *  Machine/OS name selection pattern
+ */
+#define apzClang_Macro___Has_BuiltinMachs (const char**)NULL
+
+/*
+ *  content selection pattern - do fix if pattern found
+ */
+tSCC zClang_Macro___Has_BuiltinSelect0[] =
+       "__has_builtin";
+
+/*
+ *  content bypass pattern - skip fix if pattern found
+ */
+tSCC zClang_Macro___Has_BuiltinBypass0[] =
+       "#[ \t]*define[ \t]+__has_builtin";
+
+#define    CLANG_MACRO___HAS_BUILTIN_TEST_CT  2
+static tTestDesc aClang_Macro___Has_BuiltinTests[] = {
+  { TT_NEGREP,   zClang_Macro___Has_BuiltinBypass0, (regex_t*)NULL },
+  { TT_EGREP,    zClang_Macro___Has_BuiltinSelect0, (regex_t*)NULL }, };
+
+/*
+ *  Fix Command Arguments for Clang_Macro___Has_Builtin
+ */
+static const char* apzClang_Macro___Has_BuiltinPatch[] = {
+    "wrap",
+    "#ifndef __has_builtin\n\
+  #define __has_builtin(x) 0\n\
+#endif\n",
+    (char*)NULL };
+
+/* * * * * * * * * * * * * * * * * * * * * * * * * *
+ *
+ *  Description of Clang_Macro___Has_Feature fix
+ */
+tSCC zClang_Macro___Has_FeatureName[] =
+     "clang_macro___has_feature";
+
+/*
+ *  File name selection pattern
+ */
+#define zClang_Macro___Has_FeatureList (char*)NULL
+/*
+ *  Machine/OS name selection pattern
+ */
+#define apzClang_Macro___Has_FeatureMachs (const char**)NULL
+
+/*
+ *  content selection pattern - do fix if pattern found
+ */
+tSCC zClang_Macro___Has_FeatureSelect0[] =
+       "__has_feature";
+
+/*
+ *  content bypass pattern - skip fix if pattern found
+ */
+tSCC zClang_Macro___Has_FeatureBypass0[] =
+       "#[ \t]*define[ \t]+__has_feature";
+
+#define    CLANG_MACRO___HAS_FEATURE_TEST_CT  2
+static tTestDesc aClang_Macro___Has_FeatureTests[] = {
+  { TT_NEGREP,   zClang_Macro___Has_FeatureBypass0, (regex_t*)NULL },
+  { TT_EGREP,    zClang_Macro___Has_FeatureSelect0, (regex_t*)NULL }, };
+
+/*
+ *  Fix Command Arguments for Clang_Macro___Has_Feature
+ */
+static const char* apzClang_Macro___Has_FeaturePatch[] = {
+    "wrap",
+    "#ifndef __has_feature\n\
+  #define __has_feature(x) 0\n\
+#endif\n",
+    (char*)NULL };
+
+/* * * * * * * * * * * * * * * * * * * * * * * * * *
+ *
+ *  Description of Clang_Macro___Has_Cpp_Attribute fix
+ */
+tSCC zClang_Macro___Has_Cpp_AttributeName[] =
+     "clang_macro___has_cpp_attribute";
+
+/*
+ *  File name selection pattern
+ */
+#define zClang_Macro___Has_Cpp_AttributeList (char*)NULL
+/*
+ *  Machine/OS name selection pattern
+ */
+#define apzClang_Macro___Has_Cpp_AttributeMachs (const char**)NULL
+
+/*
+ *  content selection pattern - do fix if pattern found
+ */
+tSCC zClang_Macro___Has_Cpp_AttributeSelect0[] =
+       "__has_cpp_attribute";
+
+/*
+ *  content bypass pattern - skip fix if pattern found
+ */
+tSCC zClang_Macro___Has_Cpp_AttributeBypass0[] =
+       "#[ \t]*define[ \t]+__has_cpp_attribute";
+
+#define    CLANG_MACRO___HAS_CPP_ATTRIBUTE_TEST_CT  2
+static tTestDesc aClang_Macro___Has_Cpp_AttributeTests[] = {
+  { TT_NEGREP,   zClang_Macro___Has_Cpp_AttributeBypass0, (regex_t*)NULL },
+  { TT_EGREP,    zClang_Macro___Has_Cpp_AttributeSelect0, (regex_t*)NULL }, };
+
+/*
+ *  Fix Command Arguments for Clang_Macro___Has_Cpp_Attribute
+ */
+static const char* apzClang_Macro___Has_Cpp_AttributePatch[] = {
+    "wrap",
+    "#ifndef __has_cpp_attribute\n\
+  #define __has_cpp_attribute(x) 0\n\
+#endif\n",
+    (char*)NULL };
+
+/* * * * * * * * * * * * * * * * * * * * * * * * * *
+ *
+ *  Description of Clang_Macro___Has_Attribute fix
+ */
+tSCC zClang_Macro___Has_AttributeName[] =
+     "clang_macro___has_attribute";
+
+/*
+ *  File name selection pattern
+ */
+#define zClang_Macro___Has_AttributeList (char*)NULL
+/*
+ *  Machine/OS name selection pattern
+ */
+#define apzClang_Macro___Has_AttributeMachs (const char**)NULL
+
+/*
+ *  content selection pattern - do fix if pattern found
+ */
+tSCC zClang_Macro___Has_AttributeSelect0[] =
+       "__has_attribute";
+
+/*
+ *  content bypass pattern - skip fix if pattern found
+ */
+tSCC zClang_Macro___Has_AttributeBypass0[] =
+       "#[ \t]*define[ \t]+__has_attribute";
+
+#define    CLANG_MACRO___HAS_ATTRIBUTE_TEST_CT  2
+static tTestDesc aClang_Macro___Has_AttributeTests[] = {
+  { TT_NEGREP,   zClang_Macro___Has_AttributeBypass0, (regex_t*)NULL },
+  { TT_EGREP,    zClang_Macro___Has_AttributeSelect0, (regex_t*)NULL }, };
+
+/*
+ *  Fix Command Arguments for Clang_Macro___Has_Attribute
+ */
+static const char* apzClang_Macro___Has_AttributePatch[] = {
+    "wrap",
+    "#ifndef __has_attribute\n\
+  #define __has_attribute(x) 0\n\
+#endif\n",
+    (char*)NULL };
+
+/* * * * * * * * * * * * * * * * * * * * * * * * * *
+ *
+ *  Description of Clang_Macro___Has_Declspec_Attribute fix
+ */
+tSCC zClang_Macro___Has_Declspec_AttributeName[] =
+     "clang_macro___has_declspec_attribute";
+
+/*
+ *  File name selection pattern
+ */
+#define zClang_Macro___Has_Declspec_AttributeList (char*)NULL
+/*
+ *  Machine/OS name selection pattern
+ */
+#define apzClang_Macro___Has_Declspec_AttributeMachs (const char**)NULL
+
+/*
+ *  content selection pattern - do fix if pattern found
+ */
+tSCC zClang_Macro___Has_Declspec_AttributeSelect0[] =
+       "__has_declspec_attribute";
+
+/*
+ *  content bypass pattern - skip fix if pattern found
+ */
+tSCC zClang_Macro___Has_Declspec_AttributeBypass0[] =
+       "#[ \t]*define[ \t]+__has_declspec_attribute";
+
+#define    CLANG_MACRO___HAS_DECLSPEC_ATTRIBUTE_TEST_CT  2
+static tTestDesc aClang_Macro___Has_Declspec_AttributeTests[] = {
+  { TT_NEGREP,   zClang_Macro___Has_Declspec_AttributeBypass0, (regex_t*)NULL },
+  { TT_EGREP,    zClang_Macro___Has_Declspec_AttributeSelect0, (regex_t*)NULL }, };
+
+/*
+ *  Fix Command Arguments for Clang_Macro___Has_Declspec_Attribute
+ */
+static const char* apzClang_Macro___Has_Declspec_AttributePatch[] = {
+    "wrap",
+    "#ifndef __has_declspec_attribute\n\
+  #define __has_declspec_attribute(x) 0\n\
+#endif\n",
+    (char*)NULL };
+
+/* * * * * * * * * * * * * * * * * * * * * * * * * *
+ *
  *  Description of Ctrl_Quotes_Def fix
  */
 tSCC zCtrl_Quotes_DefName[] =
@@ -6193,11 +6408,11 @@ static const char* apzSolaris_Complex_Cx
     "-e", "/#if[ \t]*!defined(__cplusplus)/c\\\n\
 #ifdef\t__cplusplus\\\n\
 extern \"C\" {\\\n\
-#endif",
+#endif\\\n",
     "-e", "/#endif[ \t]*\\/\\* !defined(__cplusplus) \\*\\//c\\\n\
 #ifdef\t__cplusplus\\\n\
 }\\\n\
-#endif",
+#endif\\\n",
     (char*)NULL };
 
 /* * * * * * * * * * * * * * * * * * * * * * * * * *
@@ -9304,9 +9519,9 @@ static const char* apzFeraiseexcept_Noss
  *
  *  List of all fixes
  */
-#define REGEX_COUNT          265
+#define REGEX_COUNT          275
 #define MACH_LIST_SIZE_LIMIT 187
-#define FIX_COUNT            227
+#define FIX_COUNT            232
 
 /*
  *  Enumerate the fixes
@@ -9359,6 +9574,11 @@ typedef enum {
     BROKEN_NAN_FIXIDX,
     BSD_STDIO_ATTRS_CONFLICT_FIXIDX,
     CDEF_CPLUSPLUS_FIXIDX,
+    CLANG_MACRO___HAS_BUILTIN_FIXIDX,
+    CLANG_MACRO___HAS_FEATURE_FIXIDX,
+    CLANG_MACRO___HAS_CPP_ATTRIBUTE_FIXIDX,
+    CLANG_MACRO___HAS_ATTRIBUTE_FIXIDX,
+    CLANG_MACRO___HAS_DECLSPEC_ATTRIBUTE_FIXIDX,
     CTRL_QUOTES_DEF_FIXIDX,
     CTRL_QUOTES_USE_FIXIDX,
     CXX_UNREADY_FIXIDX,
@@ -9777,6 +9997,31 @@ tFixDesc fixDescList[ FIX_COUNT ] = {
      CDEF_CPLUSPLUS_TEST_CT, FD_MACH_ONLY | FD_SUBROUTINE,
      aCdef_CplusplusTests,   apzCdef_CplusplusPatch, 0 },
 
+  {  zClang_Macro___Has_BuiltinName,    zClang_Macro___Has_BuiltinList,
+     apzClang_Macro___Has_BuiltinMachs,
+     CLANG_MACRO___HAS_BUILTIN_TEST_CT, FD_MACH_ONLY | FD_SUBROUTINE,
+     aClang_Macro___Has_BuiltinTests,   apzClang_Macro___Has_BuiltinPatch, 0 },
+
+  {  zClang_Macro___Has_FeatureName,    zClang_Macro___Has_FeatureList,
+     apzClang_Macro___Has_FeatureMachs,
+     CLANG_MACRO___HAS_FEATURE_TEST_CT, FD_MACH_ONLY | FD_SUBROUTINE,
+     aClang_Macro___Has_FeatureTests,   apzClang_Macro___Has_FeaturePatch, 0 },
+
+  {  zClang_Macro___Has_Cpp_AttributeName,    zClang_Macro___Has_Cpp_AttributeList,
+     apzClang_Macro___Has_Cpp_AttributeMachs,
+     CLANG_MACRO___HAS_CPP_ATTRIBUTE_TEST_CT, FD_MACH_ONLY | FD_SUBROUTINE,
+     aClang_Macro___Has_Cpp_AttributeTests,   apzClang_Macro___Has_Cpp_AttributePatch, 0 },
+
+  {  zClang_Macro___Has_AttributeName,    zClang_Macro___Has_AttributeList,
+     apzClang_Macro___Has_AttributeMachs,
+     CLANG_MACRO___HAS_ATTRIBUTE_TEST_CT, FD_MACH_ONLY | FD_SUBROUTINE,
+     aClang_Macro___Has_AttributeTests,   apzClang_Macro___Has_AttributePatch, 0 },
+
+  {  zClang_Macro___Has_Declspec_AttributeName,    zClang_Macro___Has_Declspec_AttributeList,
+     apzClang_Macro___Has_Declspec_AttributeMachs,
+     CLANG_MACRO___HAS_DECLSPEC_ATTRIBUTE_TEST_CT, FD_MACH_ONLY | FD_SUBROUTINE,
+     aClang_Macro___Has_Declspec_AttributeTests,   apzClang_Macro___Has_Declspec_AttributePatch, 0 },
+
   {  zCtrl_Quotes_DefName,    zCtrl_Quotes_DefList,
      apzCtrl_Quotes_DefMachs,
      CTRL_QUOTES_DEF_TEST_CT, FD_MACH_ONLY | FD_SUBROUTINE,
