$NetBSD: patch-Modules_sunaudiodev.c,v 1.1 2018/06/17 19:21:21 adam Exp $

XXXbjs:  I use amd64, and audioop is broken on 64-bit platforms.
Thus, this needs to be tested.

--- Modules/sunaudiodev.c.orig	2014-12-10 15:59:55.000000000 +0000
+++ Modules/sunaudiodev.c
@@ -224,7 +224,11 @@ sad_ibufcount(sadobject *self)
 {
     audio_info_t ai;
 
+#if defined(__NetBSD__) && defined(AUDIO_GETBUFINFO)
+    if (ioctl(self->x_fd, AUDIO_GEBUFTINFO, &ai) < 0) {
+#else
     if (ioctl(self->x_fd, AUDIO_GETINFO, &ai) < 0) {
+#endif
         PyErr_SetFromErrno(SunAudioError);
         return NULL;
     }
@@ -236,7 +240,11 @@ sad_obufcount(sadobject *self)
 {
     audio_info_t ai;
 
+#if defined(__NetBSD__) && defined(AUDIO_GETBUFINFO)
+    if (ioctl(self->x_fd, AUDIO_GETBUFINFO, &ai) < 0) {
+#else
     if (ioctl(self->x_fd, AUDIO_GETINFO, &ai) < 0) {
+#endif
         PyErr_SetFromErrno(SunAudioError);
         return NULL;
     }
@@ -275,7 +283,11 @@ sad_getdev(sadobject *self)
 static PyObject *
 sad_flush(sadobject *self)
 {
+#if defined(__NetBSD__) || defined(__OpenBSD__)
+    if (ioctl(self->x_fd, AUDIO_FLUSH, NULL) < 0) {
+#else
     if (ioctl(self->x_fd, I_FLUSH, FLUSHW) < 0) {
+#endif
         PyErr_SetFromErrno(SunAudioError);
         return NULL;
     }
