$NetBSD: patch-ansi.c,v 1.3 2021/03/13 07:24:04 kim Exp $

https://salsa.debian.org/debian/screen/-/raw/master/debian/patches/52fix_screen_utf8_nfd.patch

Author: Michael Schröder <mls@suse.de>
Reviewed-By: Axel Beckert <abe@debian.org>
Description: screen outputs screen "ÿ" after a connected character.
 This is a character without the need. 
 This happens in UTF-8 environment. 
 Before : screen$ ruby1.9.1 -e 'puts "\u304b\u3099.."'
          がÿ...
 patch applied :  screen $ ruby1.9.1 -e 'puts "\u304b\u3099.."'
          が..
Origin: https://lists.gnu.org/archive/html/screen-devel/2021-02/msg00012.html
Bugs-Debian: https://bugs.debian.org/600246
Bugs-Debian: https://bugs.debian.org/677512

diff --git a/ansi.c b/ansi.c
index 2a52edd..83b266d 100644
--- ansi.c.orig
+++ ansi.c
@@ -692,10 +692,6 @@ register int len;
 		    }
 		  curr->w_rend.font = 0;
 		}
-#  ifdef DW_CHARS
-	      if (curr->w_encoding == UTF8 && utf8_isdouble(c))
-		curr->w_mbcs = 0xff;
-#  endif
 	      if (curr->w_encoding == UTF8 && c >= 0x0300 && utf8_iscomb(c))
 		{
 		  int ox, oy;
@@ -730,6 +726,10 @@ register int len;
 		    }
 		  break;
 		}
+#  ifdef DW_CHARS
+	      if (curr->w_encoding == UTF8 && utf8_isdouble(c))
+		curr->w_mbcs = 0xff;
+#  endif
 	      font = curr->w_rend.font;
 # endif
 # ifdef DW_CHARS
