$NetBSD: patch-xxhash.h,v 1.1 2022/03/31 15:36:08 sborrill Exp $

No longer depend on `<assert.h>` for XXH_STATIC_ASSERT since some
versions are buggy.

Use `_Static_assert` instead, which is part of the C11 language.

https://github.com/Cyan4973/xxHash/issues/671
https://github.com/Cyan4973/xxHash/commit/6189ecd3d44a693460f86280ccf49d33cb4b18e1
--- xxhash.h.orig	2021-11-29 12:34:10.000000000 -0600
+++ xxhash.h	2021-12-28 19:55:42.000000000 -0600
@@ -1546,8 +1546,7 @@
 /* note: use after variable declarations */
 #ifndef XXH_STATIC_ASSERT
 #  if defined(__STDC_VERSION__) && (__STDC_VERSION__ >= 201112L)    /* C11 */
-#    include <assert.h>
-#    define XXH_STATIC_ASSERT_WITH_MESSAGE(c,m) do { static_assert((c),m); } while(0)
+#    define XXH_STATIC_ASSERT_WITH_MESSAGE(c,m) do { _Static_assert((c),m); } while(0)
 #  elif defined(__cplusplus) && (__cplusplus >= 201103L)            /* C++11 */
 #    define XXH_STATIC_ASSERT_WITH_MESSAGE(c,m) do { static_assert((c),m); } while(0)
 #  else
