$NetBSD: patch-src_fcatomic.h,v 1.1 2021/09/11 23:34:44 tnn Exp $

Fix crash on mac OS aarch64. From upstream:

From 6def66164a36eed968aae872d76acfac3173d44a Mon Sep 17 00:00:00 2001
From: Nirbheek Chauhan <nirbheek@centricular.com>
Date: Sat, 22 Feb 2020 03:57:50 +0530
Subject: [PATCH] fcatomic: Fix EXC_BAD_ACCESS on iOS ARM64

iPhone 2.1 was released a long time ago, and the macro for checking
the target iOS SDK version has changed. We can simplify everything and
do a very basic check.

--- src/fcatomic.h.orig	2016-12-02 03:22:19.000000000 +0000
+++ src/fcatomic.h
@@ -70,24 +70,16 @@ typedef LONG fc_atomic_int_t;
 #elif !defined(FC_NO_MT) && defined(__APPLE__)
 
 #include <libkern/OSAtomic.h>
-#ifdef __MAC_OS_X_MIN_REQUIRED
 #include <AvailabilityMacros.h>
-#elif defined(__IPHONE_OS_MIN_REQUIRED)
-#include <Availability.h>
-#endif
 
 typedef int fc_atomic_int_t;
 #define fc_atomic_int_add(AI, V)	(OSAtomicAdd32Barrier ((V), &(AI)) - (V))
 
 #define fc_atomic_ptr_get(P)		(OSMemoryBarrier (), (void *) *(P))
-#if (MAC_OS_X_VERSION_MIN_REQUIRED > MAC_OS_X_VERSION_10_4 || __IPHONE_VERSION_MIN_REQUIRED >= 20100)
+#if (MAC_OS_X_VERSION_MIN_REQUIRED > MAC_OS_X_VERSION_10_4 || __IPHONE_OS_VERSION_MIN_REQUIRED >= 20100)
 #define fc_atomic_ptr_cmpexch(P,O,N)	OSAtomicCompareAndSwapPtrBarrier ((void *) (O), (void *) (N), (void **) (P))
 #else
-#if __ppc64__ || __x86_64__
-#define fc_atomic_ptr_cmpexch(P,O,N)	OSAtomicCompareAndSwap64Barrier ((int64_t) (O), (int64_t) (N), (int64_t*) (P))
-#else
-#define fc_atomic_ptr_cmpexch(P,O,N)	OSAtomicCompareAndSwap32Barrier ((int32_t) (O), (int32_t) (N), (int32_t*) (P))
-#endif
+#error "Your macOS / iOS targets are too old"
 #endif
 
 #elif !defined(FC_NO_MT) && defined(HAVE_INTEL_ATOMIC_PRIMITIVES)
