# $NetBSD: gfortran.mk,v 1.20 2022/04/04 15:38:47 jperkin Exp $
#
# Copyright (c) 2005 The NetBSD Foundation, Inc.
# All rights reserved.
#
# This code is derived from software contributed to The NetBSD Foundation
# by Johnny C. Lam.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
# ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
# TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
# PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
# BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
#

.if !defined(COMPILER_GFORTRAN_MK)
COMPILER_GFORTRAN_MK=	defined

.include "../../mk/bsd.prefs.mk"

# If pkgsrc base compiler is GCC, match the gfortran requirement as closely as
# possible.  Otherwise, default to a mainstream version and hope for the best.
# If base compiler is clang, we really should use flang rather than gfortran.
# \todo Perhaps adjust this so that gcc-4.8.3 maps to 48, or document that 4.8
# is so old that we intend what seems like a bug to choose the modern version
# in that case.
POSSIBLE_GFORTRAN_VERSION?=	${CC_VERSION:S/gcc-//:C/.[0-9].[0-9]$//}

# gcc9 doesn't work on NetBSD/arm, but gcc10 does.
.if !empty(POSSIBLE_GFORTRAN_VERSION:M9) && \
    !empty(MACHINE_PLATFORM:MNetBSD-*-aarch64*)
POSSIBLE_GFORTRAN_VERSION=	10
.endif

.if !empty(POSSIBLE_GFORTRAN_VERSION:M[0-9]) && \
    !empty(MACHINE_PLATFORM:MNetBSD-*-earm*)
POSSIBLE_GFORTRAN_VERSION=	10
.endif

.if !empty(PKGSRC_COMPILER:Mgcc) && \
    exists(${PKGSRCDIR}/lang/gcc${POSSIBLE_GFORTRAN_VERSION}/buildlink3.mk)
GFORTRAN_VERSION?=		${POSSIBLE_GFORTRAN_VERSION}
.else
GFORTRAN_VERSION?=		7
.endif

.if !empty(PKGPATH:Mlang/gcc${GFORTRAN_VERSION}) || !empty(PKGPATH:Mdevel/patch) || \
    !empty(PKGPATH:Mdevel/libtool-base)
IGNORE_GFORTRAN=	yes
MAKEFLAGS+=		IGNORE_GFORTRAN=yes
.endif

.if defined(IGNORE_GFORTRAN)
_USE_GFORTRAN=	NO
.endif

# LANGUAGES.<compiler> is the list of supported languages by the compiler.
# _LANGUAGES.<compiler> is ${LANGUAGES.<compiler>} restricted to the ones
# requested by the package in USE_LANGUAGES.
#
LANGUAGES.gfortran=	fortran fortran77
_LANGUAGES.gfortran=	# empty
.for _lang_ in ${USE_LANGUAGES}
_LANGUAGES.gfortran+=	${LANGUAGES.gfortran:M${_lang_}}
.endfor
.if empty(_LANGUAGES.gfortran)
_USE_GFORTRAN=	NO
.endif

.if !defined(_USE_GFORTRAN)
_USE_GFORTRAN=	YES
.endif

.if !empty(_USE_GFORTRAN:M[yY][eE][sS])
_GFORTRANBASE=	${LOCALBASE}/gcc${GFORTRAN_VERSION}
FC=		gfortran

_GFORTRAN_DIR=	${WRKDIR}/.gfortran
_GFORTRAN_VARS=	# empty
.  if !empty(_LANGUAGES.gfortran:Mfortran) || \
      !empty(_LANGUAGES.gfortran:Mfortran77)
PKG_FC?=	${FC}
_GFORTRAN_VARS+=	FC
_GFORTRAN_FC:=	${_GFORTRAN_DIR}/bin/${PKG_FC:T}
_ALIASES.FC+=	f77 g77 g95 gfortran
FCPATH=		${_GFORTRANBASE}/bin/gfortran
PKG_FC:=	${_GFORTRAN_FC}
.  endif

# Prepend the path the to the compiler to the PATH
.  if !empty(_LANGUAGES.gfortran)
PREPEND_PATH+=	${_GFORTRAN_DIR}/bin
.  endif

# Add the dependency on gfortran.
BUILDLINK_DEPMETHOD.gcc${GFORTRAN_VERSION}=	full
.  include "../../lang/gcc${GFORTRAN_VERSION}/buildlink3.mk"

.  if defined(GFORTRAN_DIR) && !empty(GFORTRAN_DIR)
PKGSRC_MAKE_ENV+=	GFORTRAN_DIR=${GFORTRAN_DIR:Q}
.  endif

# Create symlinks for the compiler into ${WRKDIR}.
.  for _var_ in ${_GFORTRAN_VARS}
.    if !target(${_GFORTRAN_${_var_}})
override-tools: ${_GFORTRAN_${_var_}}
${_GFORTRAN_${_var_}}:
	${RUN}${MKDIR} ${.TARGET:H}
	${RUN}					\
	${LN} -fs ${_GFORTRANBASE}/bin/gfortran ${.TARGET}
.      for _alias_ in ${_ALIASES.${_var_}:S/^/${.TARGET:H}\//}
	${RUN}					\
	if [ ! -x "${_alias_}" ]; then					\
		${LN} -fs ${_GFORTRANBASE}/bin/gfortran ${_alias_};		\
	fi
.      endfor
.    endif
.  endfor
.endif	# _USE_GFORTRAN == "yes"

.endif	# COMPILER_GFORTRAN_MK
