$NetBSD: patch-xvpng.c,v 1.1 2019/02/21 14:32:32 tsutsui Exp $

Fix build with libpng 1.5.
Fix CVE-2017-18215 from https://bugzilla.suse.com/show_bug.cgi?id=1043479

--- xvpng.c.orig	2007-05-14 00:53:28.000000000 +0000
+++ xvpng.c
@@ -31,6 +31,7 @@
 
 #ifdef HAVE_PNG
 
+#include "zlib.h"
 #include "png.h"
 
 /*** Stuff for PNG Dialog box ***/
@@ -41,7 +42,7 @@
 #define COMPRESSION   6     /* default zlib compression level, not max
                                (Z_BEST_COMPRESSION) */
 
-#define HAVE_tRNS  (info_ptr->valid & PNG_INFO_tRNS)
+#define HAVE_tRNS  (png_get_valid(png_ptr, info_ptr, PNG_INFO_tRNS))
 
 #define DWIDE    86
 #define DHIGH    104
@@ -435,6 +436,16 @@ int WritePNG(fp, pic, ptype, w, h, rmap,
 {
   png_struct *png_ptr;
   png_info   *info_ptr;
+  struct {
+    /* IHDR */
+    png_uint_32 width;
+    png_uint_32 height;
+    int bit_depth;
+    int color_type;
+    int interlace_type;
+    /* PLTE */
+    int use_palette;
+  } info_tmp;
   png_color   palette[256];
   png_textp   text;
   byte        r1[256], g1[256], b1[256];  /* storage for deduped palette */
@@ -444,6 +455,7 @@ int WritePNG(fp, pic, ptype, w, h, rmap,
   byte       *p, *png_line;
   char        software[256];
   char       *savecmnt;
+  int         num_text, max_text;
 
   if ((png_ptr = png_create_write_struct(PNG_LIBPNG_VER_STRING, NULL,
        png_xv_error, png_xv_warning)) == NULL) {
@@ -458,7 +470,7 @@ int WritePNG(fp, pic, ptype, w, h, rmap,
     FatalError(software);
   }
 
-  if (setjmp(png_ptr->jmpbuf)) {
+  if (setjmp(png_jmpbuf(png_ptr))) {
     png_destroy_write_struct(&png_ptr, &info_ptr);
     return -1;
   }
@@ -489,8 +501,8 @@ int WritePNG(fp, pic, ptype, w, h, rmap,
     png_set_filter(png_ptr, 0, filter);
   }
 
-  info_ptr->width = w;
-  info_ptr->height = h;
+  info_tmp.width = w;
+  info_tmp.height = h;
   if (w <= 0 || h <= 0) {
     SetISTR(ISTR_WARNING, "%s:  image dimensions out of range (%dx%d)",
       fbasename, w, h);
@@ -498,7 +510,8 @@ int WritePNG(fp, pic, ptype, w, h, rmap,
     return -1;
   }
 
-  info_ptr->interlace_type = interCB.val ? 1 : 0;
+  info_tmp.interlace_type =
+    interCB.val ? PNG_INTERLACE_ADAM7 : PNG_INTERLACE_NONE;
 
   linesize = 0;   /* quiet a compiler warning */
 
@@ -542,40 +555,40 @@ int WritePNG(fp, pic, ptype, w, h, rmap,
         png_destroy_write_struct(&png_ptr, &info_ptr);
         return -1;
       }
-      info_ptr->color_type = PNG_COLOR_TYPE_RGB;
-      info_ptr->bit_depth = 8;
+      info_tmp.color_type = PNG_COLOR_TYPE_RGB;
+      info_tmp.bit_depth = 8;
+      info_tmp.use_palette = 0;
     } else /* ptype == PIC8 */ {
       linesize = w;
-      info_ptr->color_type = PNG_COLOR_TYPE_PALETTE;
+      info_tmp.color_type = PNG_COLOR_TYPE_PALETTE;
       if (numuniqcols <= 2)
-        info_ptr->bit_depth = 1;
+        info_tmp.bit_depth = 1;
       else
       if (numuniqcols <= 4)
-        info_ptr->bit_depth = 2;
+        info_tmp.bit_depth = 2;
       else
       if (numuniqcols <= 16)
-        info_ptr->bit_depth = 4;
+        info_tmp.bit_depth = 4;
       else
-        info_ptr->bit_depth = 8;
+        info_tmp.bit_depth = 8;
 
       for (i = 0; i < numuniqcols; i++) {
         palette[i].red   = r1[i];
         palette[i].green = g1[i];
         palette[i].blue  = b1[i];
       }
-      info_ptr->num_palette = numuniqcols;
-      info_ptr->palette = palette;
-      info_ptr->valid |= PNG_INFO_PLTE;
+      info_tmp.use_palette = 1;
     }
   }
 
   else if (colorType == F_GREYSCALE || colorType == F_BWDITHER) {
-    info_ptr->color_type = PNG_COLOR_TYPE_GRAY;
+    info_tmp.color_type = PNG_COLOR_TYPE_GRAY;
+    info_tmp.use_palette = 0;
     if (colorType == F_BWDITHER) {
       /* shouldn't happen */
       if (ptype == PIC24) FatalError("PIC24 and B/W Stipple in WritePNG()");
 
-      info_ptr->bit_depth = 1;
+      info_tmp.bit_depth = 1;
       if (MONO(r1[0], g1[0], b1[0]) > MONO(r1[1], g1[1], b1[1])) {
         remap[0] = 1;
         remap[1] = 0;
@@ -595,7 +608,7 @@ int WritePNG(fp, pic, ptype, w, h, rmap,
           png_destroy_write_struct(&png_ptr, &info_ptr);
           return -1;
         }
-        info_ptr->bit_depth = 8;
+        info_tmp.bit_depth = 8;
       }
       else /* ptype == PIC8 */ {
         int low_precision;
@@ -617,7 +630,7 @@ int WritePNG(fp, pic, ptype, w, h, rmap,
         for (; i < 256; i++)
           remap[i]=0;  /* shouldn't be necessary, but... */
 
-        info_ptr->bit_depth = 8;
+        info_tmp.bit_depth = 8;
 
         /* Note that this fails most of the time because of gamma */
            /* (and that would be a bug:  GRR FIXME) */
@@ -636,7 +649,7 @@ int WritePNG(fp, pic, ptype, w, h, rmap,
           for (i = 0; i < numuniqcols; i++) {
             remap[i] &= 0xf;
           }
-          info_ptr->bit_depth = 4;
+          info_tmp.bit_depth = 4;
 
           /* try to adjust to 2-bit precision grayscale */
 
@@ -652,7 +665,7 @@ int WritePNG(fp, pic, ptype, w, h, rmap,
           for (i = 0; i < numuniqcols; i++) {
             remap[i] &= 3;
           }
-          info_ptr->bit_depth = 2;
+          info_tmp.bit_depth = 2;
 
           /* try to adjust to 1-bit precision grayscale */
 
@@ -668,7 +681,7 @@ int WritePNG(fp, pic, ptype, w, h, rmap,
           for (i = 0; i < numuniqcols; i++) {
             remap[i] &= 1;
           }
-          info_ptr->bit_depth = 1;
+          info_tmp.bit_depth = 1;
         }
       }
     }
@@ -677,6 +690,20 @@ int WritePNG(fp, pic, ptype, w, h, rmap,
   else
     png_error(png_ptr, "Unknown colorstyle in WritePNG");
 
+  png_set_IHDR(png_ptr, info_ptr,
+	       info_tmp.width, info_tmp.height,
+	       info_tmp.bit_depth, info_tmp.color_type,
+	       info_tmp.interlace_type, PNG_COMPRESSION_TYPE_BASE,
+	       PNG_FILTER_TYPE_BASE);
+  if (info_tmp.use_palette) {
+    /*
+     * info_ptr->num_palette = numuniqcols;
+     * info_ptr->palette = palette;
+     * info_ptr->valid |= PNG_INFO_PLTE;
+     */
+    png_set_PLTE(png_ptr, info_ptr, palette, numuniqcols);
+  }
+
   if ((text = (png_textp)malloc(sizeof(png_text)))) {
     sprintf(software, "XV %s", REVDATE);
 
@@ -684,21 +711,29 @@ int WritePNG(fp, pic, ptype, w, h, rmap,
     text->key = "Software";
     text->text = software;
     text->text_length = strlen(text->text);
+    text->lang = NULL;
 
-    info_ptr->max_text = 1;
-    info_ptr->num_text = 1;
-    info_ptr->text = text;
+    /*
+     * info_ptr->max_text = 1;
+     * info_ptr->num_text = 1;
+     * info_ptr->text = text;
+     */
+    png_set_text(png_ptr, info_ptr, text, 1);
+    num_text = max_text = 1;
   }
 
   Display_Gamma = gDial.val;  /* Save the current gamma for loading */
 
 // GRR FIXME:  add .Xdefaults option to omit writing gamma (size, cumulative errors when editing)--alternatively, modify save box to include "omit" checkbox
-  info_ptr->gamma = 1.0/gDial.val;
-  info_ptr->valid |= PNG_INFO_gAMA;
+  /*
+   * info_ptr->gamma = 1.0/gDial.val;
+   * info_ptr->valid |= PNG_INFO_gAMA;
+   */
+  png_set_gAMA(png_ptr, info_ptr, 1.0/gDial.val);
 
   png_write_info(png_ptr, info_ptr);
 
-  if (info_ptr->bit_depth < 8)
+  if (info_tmp.bit_depth < 8)
     png_set_packing(png_ptr);
 
   pass=png_set_interlace_handling(png_ptr);
@@ -711,13 +746,13 @@ int WritePNG(fp, pic, ptype, w, h, rmap,
     int j;
     p = pic;
     for (j = 0; j < h; ++j) {
-      if (info_ptr->color_type == PNG_COLOR_TYPE_GRAY) {
+      if (info_tmp.color_type == PNG_COLOR_TYPE_GRAY) {
         int k;
         for (k = 0; k < w; ++k)
           png_line[k] = ptype==PIC24 ? MONO(p[k*3], p[k*3+1], p[k*3+2]) :
                                        remap[pc2nc[p[k]]];
         png_write_row(png_ptr, png_line);
-      } else if (info_ptr->color_type == PNG_COLOR_TYPE_PALETTE) {
+      } else if (info_tmp.color_type == PNG_COLOR_TYPE_PALETTE) {
         int k;
         for (k = 0; k < w; ++k)
           png_line[k] = pc2nc[p[k]];
@@ -743,24 +778,26 @@ int WritePNG(fp, pic, ptype, w, h, rmap,
       strcpy(savecmnt, picComments);
       key = savecmnt;
       tp = text;
-      info_ptr->num_text = 0;
+
+      png_free_data(png_ptr, info_ptr, PNG_FREE_TEXT, -1);
+      num_text = 0;
 
       comment = strchr(key, ':');
 
       do  {
         /* Allocate a larger structure for comments if necessary */
-        if (info_ptr->num_text >= info_ptr->max_text)
+        if (num_text >= max_text)
         {
           if ((tp =
-              realloc(text, (info_ptr->num_text + 2)*sizeof(png_text))) == NULL)
+              realloc(text, (num_text + 2)*sizeof(png_text))) == NULL)
           {
             break;
           }
           else
           {
             text = tp;
-            tp = &text[info_ptr->num_text];
-            info_ptr->max_text += 2;
+            tp = &text[num_text];
+            max_text += 2;
           }
         }
 
@@ -810,7 +847,7 @@ int WritePNG(fp, pic, ptype, w, h, rmap,
             }
 
             tp->compression = tp->text_length > 640 ? 0 : -1;
-            info_ptr->num_text++;
+            num_text++;
             tp++;
           }
         }
@@ -834,27 +871,29 @@ int WritePNG(fp, pic, ptype, w, h, rmap,
           tp->text = key;
           tp->text_length = q - key;
           tp->compression = tp->text_length > 750 ? 0 : -1;
-          info_ptr->num_text++;
+          num_text++;
           key = NULL;
         }
       } while (key && *key);
+      png_set_text(png_ptr, info_ptr, text, num_text);
     }
     else {
-      info_ptr->num_text = 0;
+      png_free_data(png_ptr, info_ptr, PNG_FREE_TEXT, -1);
     }
   }
-  info_ptr->text = text;
 
-  png_convert_from_time_t(&(info_ptr->mod_time), time(NULL));
-  info_ptr->valid |= PNG_INFO_tIME;
+  {
+     png_time mod_time;
+
+     png_convert_from_time_t(&mod_time, time(NULL));
+     png_set_tIME(png_ptr, info_ptr, &mod_time);
+  }
 
   png_write_end(png_ptr, info_ptr);
   fflush(fp);   /* just in case we core-dump before finishing... */
 
   if (text) {
     free(text);
-    /* must do this or png_destroy_write_struct() 0.97+ will free text again: */
-    info_ptr->text = (png_textp)NULL;
     if (savecmnt)
     {
       free(savecmnt);
@@ -886,6 +925,8 @@ int LoadPNG(fname, pinfo)
   int pass;
   int gray_to_rgb;
   size_t commentsize;
+  png_textp text;
+  int num_text;
 
   fbasename = BaseName(fname);
 
@@ -921,7 +962,7 @@ int LoadPNG(fname, pinfo)
     FatalError("malloc failure in LoadPNG");
   }
 
-  if (setjmp(png_ptr->jmpbuf)) {
+  if (setjmp(png_jmpbuf(png_ptr))) {
     fclose(fp);
     png_destroy_read_struct(&png_ptr, &info_ptr, (png_infopp)NULL);
     if (!read_anything) {
@@ -945,8 +986,8 @@ int LoadPNG(fname, pinfo)
 #endif
   png_read_info(png_ptr, info_ptr);
 
-  pinfo->w = pinfo->normw = info_ptr->width;
-  pinfo->h = pinfo->normh = info_ptr->height;
+  pinfo->w = pinfo->normw = png_get_image_width(png_ptr, info_ptr);
+  pinfo->h = pinfo->normh = png_get_image_height(png_ptr, info_ptr);
   if (pinfo->w <= 0 || pinfo->h <= 0) {
     SetISTR(ISTR_WARNING, "%s:  image dimensions out of range (%dx%d)",
       fbasename, pinfo->w, pinfo->h);
@@ -957,9 +998,9 @@ int LoadPNG(fname, pinfo)
   pinfo->frmType = F_PNG;
 
   sprintf(pinfo->fullInfo, "PNG, %d bit ",
-          info_ptr->bit_depth * info_ptr->channels);
+          png_get_bit_depth(png_ptr,info_ptr) * png_get_channels(png_ptr, info_ptr));
 
-  switch(info_ptr->color_type) {
+  switch(png_get_color_type(png_ptr, info_ptr)) {
     case PNG_COLOR_TYPE_PALETTE:
       strcat(pinfo->fullInfo, "palette color");
       break;
@@ -983,15 +1024,20 @@ int LoadPNG(fname, pinfo)
 
   sprintf(pinfo->fullInfo + strlen(pinfo->fullInfo),
 	  ", %sinterlaced. (%d bytes)",
-	  info_ptr->interlace_type ? "" : "non-", filesize);
+	  png_get_interlace_type(png_ptr, info_ptr) ? "" : "non-", filesize);
 
-  sprintf(pinfo->shrtInfo, "%lux%lu PNG", info_ptr->width, info_ptr->height);
+  sprintf(pinfo->shrtInfo, "%lux%lu PNG",
+	  png_get_image_width(png_ptr, info_ptr),
+	  png_get_image_height(png_ptr, info_ptr));
 
-  if (info_ptr->bit_depth < 8)
+  if (png_get_bit_depth(png_ptr, info_ptr) < 8)
       png_set_packing(png_ptr);
 
-  if (info_ptr->valid & PNG_INFO_gAMA)
-    png_set_gamma(png_ptr, Display_Gamma, info_ptr->gamma);
+  if (png_get_valid(png_ptr, info_ptr, PNG_INFO_gAMA)) {
+    double gamma;
+    png_get_gAMA(png_ptr, info_ptr, &gamma);
+    png_set_gamma(png_ptr, Display_Gamma, gamma);
+  }
 /*
  *else
  *  png_set_gamma(png_ptr, Display_Gamma, 0.45);
@@ -1000,7 +1046,7 @@ int LoadPNG(fname, pinfo)
   gray_to_rgb = 0;   /* quiet a compiler warning */
 
   if (have_imagebg) {
-    if (info_ptr->bit_depth == 16) {
+    if (png_get_bit_depth(png_ptr, info_ptr) == 16) {
       my_background.red   = imagebgR;
       my_background.green = imagebgG;
       my_background.blue  = imagebgB;
@@ -1013,8 +1059,8 @@ int LoadPNG(fname, pinfo)
     }
     png_set_background(png_ptr, &my_background, PNG_BACKGROUND_GAMMA_SCREEN,
                        0, Display_Gamma);
-    if ((info_ptr->color_type == PNG_COLOR_TYPE_GRAY_ALPHA ||
-         (info_ptr->color_type == PNG_COLOR_TYPE_GRAY && HAVE_tRNS)) &&
+    if ((png_get_color_type(png_ptr, info_ptr) == PNG_COLOR_TYPE_GRAY_ALPHA ||
+         (png_get_color_type(png_ptr, info_ptr) == PNG_COLOR_TYPE_GRAY && HAVE_tRNS)) &&
         (imagebgR != imagebgG || imagebgR != imagebgB))  /* i.e., colored bg */
     {
       png_set_gray_to_rgb(png_ptr);
@@ -1022,8 +1068,10 @@ int LoadPNG(fname, pinfo)
       gray_to_rgb = 1;
     }
   } else {
-    if (info_ptr->valid & PNG_INFO_bKGD) {
-      png_set_background(png_ptr, &info_ptr->background,
+    if (png_get_valid(png_ptr, info_ptr, PNG_INFO_bKGD)) {
+      png_color_16p background;
+      png_get_bKGD(png_ptr, info_ptr, &background);
+      png_set_background(png_ptr, background,
                          PNG_BACKGROUND_GAMMA_FILE, 1, 1.0);
     } else {
       my_background.red = my_background.green = my_background.blue =
@@ -1033,13 +1081,13 @@ int LoadPNG(fname, pinfo)
     }
   }
 
-  if (info_ptr->bit_depth == 16)
+  if (png_get_bit_depth(png_ptr, info_ptr) == 16)
     png_set_strip_16(png_ptr);
 
-  if (info_ptr->color_type == PNG_COLOR_TYPE_GRAY ||
-      info_ptr->color_type == PNG_COLOR_TYPE_GRAY_ALPHA)
+  if (png_get_color_type(png_ptr, info_ptr) == PNG_COLOR_TYPE_GRAY ||
+      png_get_color_type(png_ptr, info_ptr) == PNG_COLOR_TYPE_GRAY_ALPHA)
   {
-    if (info_ptr->bit_depth == 1)
+    if (png_get_bit_depth(png_ptr, info_ptr) == 1)
       pinfo->colType = F_BWDITHER;
     else
       pinfo->colType = F_GREYSCALE;
@@ -1050,8 +1098,8 @@ int LoadPNG(fname, pinfo)
 
   png_read_update_info(png_ptr, info_ptr);
 
-  if (info_ptr->color_type == PNG_COLOR_TYPE_RGB ||
-     info_ptr->color_type == PNG_COLOR_TYPE_RGB_ALPHA || gray_to_rgb)
+  if (png_get_color_type(png_ptr, info_ptr) == PNG_COLOR_TYPE_RGB ||
+     png_get_color_type(png_ptr, info_ptr) == PNG_COLOR_TYPE_RGB_ALPHA || gray_to_rgb)
   {
     linesize = 3 * pinfo->w;
     if (linesize/3 < pinfo->w) {   /* know pinfo->w > 0 (see above) */
@@ -1065,16 +1113,20 @@ int LoadPNG(fname, pinfo)
   } else {
     linesize = pinfo->w;
     pinfo->type = PIC8;
-    if (info_ptr->color_type == PNG_COLOR_TYPE_GRAY ||
-       info_ptr->color_type == PNG_COLOR_TYPE_GRAY_ALPHA) {
+    if (png_get_color_type(png_ptr, info_ptr) == PNG_COLOR_TYPE_GRAY ||
+       png_get_color_type(png_ptr, info_ptr) == PNG_COLOR_TYPE_GRAY_ALPHA) {
       for (i = 0; i < 256; i++)
         pinfo->r[i] = pinfo->g[i] = pinfo->b[i] = i;
     } else {
+      png_colorp palette;
+      int num_palette;
+
+      png_get_PLTE(png_ptr, info_ptr, &palette, &num_palette);
       pinfo->colType = F_FULLCOLOR;
-      for (i = 0; i < info_ptr->num_palette; i++) {
-        pinfo->r[i] = info_ptr->palette[i].red;
-        pinfo->g[i] = info_ptr->palette[i].green;
-        pinfo->b[i] = info_ptr->palette[i].blue;
+      for (i = 0; i < num_palette; i++) {
+        pinfo->r[i] = palette[i].red;
+        pinfo->g[i] = palette[i].green;
+        pinfo->b[i] = palette[i].blue;
       }
     }
   }
@@ -1092,7 +1144,17 @@ int LoadPNG(fname, pinfo)
     png_error(png_ptr, "can't allocate space for PNG image");
   }
 
-  png_start_read_image(png_ptr);
+  /*
+   * In png 1.5 (or at least 1.5.1beta06) calling this after calling
+   * png_read_update_info() does nothing besides issue a misleading
+   * warning message. The png docs are not at all clear on what an
+   * application is *supposed* to do, so I'm not sure if this is a
+   * problem with xv or with libpng. However, for now I'll comment
+   * this out as according to the png source that should be harmless
+   * and we don't want to see the warning message every time someone
+   * opens a png.
+   */
+  /*png_start_read_image(png_ptr);*/
 
   for (i = 0; i < pass; i++) {
     byte *p = pinfo->pic;
@@ -1106,22 +1168,23 @@ int LoadPNG(fname, pinfo)
 
   png_read_end(png_ptr, info_ptr);
 
-  if (info_ptr->num_text > 0) {
+  png_get_text(png_ptr, info_ptr, &text, &num_text);
+  if (num_text > 0) {
     commentsize = 1;
 
-    for (i = 0; i < info_ptr->num_text; i++)
-      commentsize += strlen(info_ptr->text[i].key) + 1 +
-                     info_ptr->text[i].text_length + 2;
+    for (i = 0; i < num_text; i++)
+      commentsize += strlen(text[i].key) + 1 +
+                     strlen(text[i].text) + 2;
 
     if ((pinfo->comment = malloc(commentsize)) == NULL) {
       png_warning(png_ptr,"can't allocate comment string");
     }
     else {
       pinfo->comment[0] = '\0';
-      for (i = 0; i < info_ptr->num_text; i++) {
-        strcat(pinfo->comment, info_ptr->text[i].key);
+      for (i = 0; i < num_text; i++) {
+        strcat(pinfo->comment, text[i].key);
         strcat(pinfo->comment, "::");
-        strcat(pinfo->comment, info_ptr->text[i].text);
+        strcat(pinfo->comment, text[i].text);
         strcat(pinfo->comment, "\n");
       }
     }
@@ -1143,7 +1206,7 @@ png_xv_error(png_ptr, message)
 {
   SetISTR(ISTR_WARNING,"%s:  libpng error: %s", fbasename, message);
 
-  longjmp(png_ptr->jmpbuf, 1);
+  longjmp(png_jmpbuf(png_ptr), 1);
 }
 
 
