$NetBSD: patch-lib_action__controller_metal_redirecting.rb,v 1.1.2.2 2023/07/05 11:58:47 bsiegert Exp $

Fix for CVE-2023-28362.

--- lib/action_controller/metal/redirecting.rb.orig	2023-06-27 15:27:33.969182379 +0000
+++ lib/action_controller/metal/redirecting.rb
@@ -7,6 +7,10 @@ module ActionController
     include AbstractController::Logger
     include ActionController::UrlFor
 
+    ILLEGAL_HEADER_VALUE_REGEX = /[\x00-\x08\x0A-\x1F]/.freeze
+
+    class UnsafeRedirectError < StandardError; end
+
     # Redirects the browser to the target specified in +options+. This parameter can be any one of:
     #
     # * <tt>Hash</tt> - The URL will be generated by calling url_for with the +options+.
@@ -60,7 +64,11 @@ module ActionController
       raise AbstractController::DoubleRenderError if response_body
 
       self.status        = _extract_redirect_to_status(options, response_status)
-      self.location      = _compute_redirect_to_location(request, options)
+
+      redirect_to_location = _compute_redirect_to_location(request, options)
+      _ensure_url_is_http_header_safe(redirect_to_location)
+
+      self.location      = redirect_to_location
       self.response_body = "<html><body>You are being <a href=\"#{ERB::Util.unwrapped_html_escape(response.location)}\">redirected</a>.</body></html>"
     end
 
@@ -129,5 +137,16 @@ module ActionController
       rescue ArgumentError, URI::Error
         false
       end
+
+      def _ensure_url_is_http_header_safe(url)
+        # Attempt to comply with the set of valid token characters
+        # defined for an HTTP header value in
+        # https://datatracker.ietf.org/doc/html/rfc7230#section-3.2.6
+        if url.match(ILLEGAL_HEADER_VALUE_REGEX)
+          msg = "The redirect URL #{url} contains one or more illegal HTTP header field character. " \
+            "Set of legal characters defined in https://datatracker.ietf.org/doc/html/rfc7230#section-3.2.6"
+          raise UnsafeRedirectError, msg
+        end
+      end
   end
 end
