$NetBSD: patch-lib_action__controller_metal_redirecting.rb,v 1.1.2.2 2023/07/05 12:01:27 bsiegert Exp $

Fix for CVE-2023-28362.

--- lib/action_controller/metal/redirecting.rb.orig	2023-06-27 15:31:15.462755078 +0000
+++ lib/action_controller/metal/redirecting.rb
@@ -7,6 +7,10 @@ module ActionController
     include AbstractController::Logger
     include ActionController::UrlFor
 
+    ILLEGAL_HEADER_VALUE_REGEX = /[\x00-\x08\x0A-\x1F]/.freeze
+
+    class UnsafeRedirectError < StandardError; end
+
     # Redirects the browser to the target specified in +options+. This parameter can be any one of:
     #
     # * <tt>Hash</tt> - The URL will be generated by calling url_for with the +options+.
@@ -60,7 +64,11 @@ module ActionController
       raise AbstractController::DoubleRenderError if response_body
 
       self.status        = _extract_redirect_to_status(options, response_options)
-      self.location      = _compute_redirect_to_location(request, options)
+
+      redirect_to_location = _compute_redirect_to_location(request, options)
+      _ensure_url_is_http_header_safe(redirect_to_location)
+
+      self.location      = redirect_to_location
       self.response_body = "<html><body>You are being <a href=\"#{ERB::Util.unwrapped_html_escape(response.location)}\">redirected</a>.</body></html>"
     end
 
