$NetBSD: patch-egg-compile.scm,v 1.1 2023/04/26 18:11:51 nikita Exp $

Fix CVE-2022-45145 by backporting commit a08f8f548d772ef410c672ba33a27108d8d434f3.

See: https://lists.nongnu.org/archive/html/chicken-announce/2022-11/msg00000.html

Taken from OpenBSD ports.

Index: egg-compile.scm
--- egg-compile.scm.orig
+++ egg-compile.scm
@@ -1191,7 +1191,7 @@ EOF
 
 ~a ~a~a
 ~a ~a~a
-cat >~a~a <<ENDINFO
+cat >~a~a <<'ENDINFO'
 ~aENDINFO~%
 EOF
                mkdir ddir qdir
@@ -1201,11 +1201,18 @@ EOF
        (printf #<<EOF
 
 ~a ~a~a
-echo ~a >~a~a~%
+copy /y nul ~a~a~%
+~a
 EOF
                mkdir ddir qdir
-               (string-intersperse (string-split infostr "\n") "^\n\n")
-               ddir dest)))))
+	       ddir dest
+	       (string-intersperse (map (lambda (line)
+					  (ensure-line-limit
+                                             (caretize (format "echo ~a >>~a~a"
+                                                               line ddir dest))
+                                             8191 ))
+					(string-split infostr "\n"))
+				   "\n"))))))
 
 ;;; some utilities for mangling + quoting
 
@@ -1277,3 +1284,12 @@ EOF
 (define (joins strs) (string-intersperse strs " "))
 
 (define (maybe f x) (if f (list x) '()))
+
+(define (caretize str)
+  (string-translate* str '(("&" . "^&") ("^" . "^^") ("|" . "^|")
+			   ("<" . "^<") (">" . "^>"))))
+
+(define (ensure-line-limit str lim)
+  (when (>= (string-length str) lim)
+    (error "line length exceeds platform limit: " str))
+  str)
