$NetBSD: patch-src_3rdparty_chromium_third__party_blink_renderer_bindings_scripts_utilities.py,v 1.1 2023/06/08 20:38:06 markd Exp $

build with python3

--- src/3rdparty/chromium/third_party/blink/renderer/bindings/scripts/utilities.py.orig	2022-03-30 09:48:18.000000000 +0000
+++ src/3rdparty/chromium/third_party/blink/renderer/bindings/scripts/utilities.py
@@ -196,8 +196,9 @@ class ComponentInfoProviderModules(Compo
 
     @property
     def callback_functions(self):
-        return dict(self._component_info_core['callback_functions'].items() +
-                    self._component_info_modules['callback_functions'].items())
+        return dict(
+            list(self._component_info_core['callback_functions'].items()) +
+            list(self._component_info_modules['callback_functions'].items()))
 
     @property
     def specifier_for_export(self):
@@ -209,8 +210,8 @@ class ComponentInfoProviderModules(Compo
 
 
 def load_interfaces_info_overall_pickle(info_dir):
-    with open(os.path.join(info_dir,
-                           'interfaces_info.pickle')) as interface_info_file:
+    with open(os.path.join(info_dir, 'interfaces_info.pickle'),
+              mode='rb') as interface_info_file:
         return pickle.load(interface_info_file)
 
 
@@ -236,23 +237,20 @@ def merge_dict_recursively(target, diff)
 
 def create_component_info_provider_core(info_dir):
     interfaces_info = load_interfaces_info_overall_pickle(info_dir)
-    with open(
-            os.path.join(info_dir, 'core',
-                         'component_info_core.pickle')) as component_info_file:
+    with open(os.path.join(info_dir, 'core', 'component_info_core.pickle'),
+              mode='rb') as component_info_file:
         component_info = pickle.load(component_info_file)
     return ComponentInfoProviderCore(interfaces_info, component_info)
 
 
 def create_component_info_provider_modules(info_dir):
     interfaces_info = load_interfaces_info_overall_pickle(info_dir)
-    with open(
-            os.path.join(info_dir, 'core',
-                         'component_info_core.pickle')) as component_info_file:
+    with open(os.path.join(info_dir, 'core', 'component_info_core.pickle'),
+              mode='rb') as component_info_file:
         component_info_core = pickle.load(component_info_file)
-    with open(
-            os.path.join(
-                info_dir, 'modules',
-                'component_info_modules.pickle')) as component_info_file:
+    with open(os.path.join(info_dir, 'modules',
+                           'component_info_modules.pickle'),
+              mode='rb') as component_info_file:
         component_info_modules = pickle.load(component_info_file)
     return ComponentInfoProviderModules(interfaces_info, component_info_core,
                                         component_info_modules)
@@ -356,7 +354,7 @@ def write_pickle_file(pickle_filename, d
     pickle_filename = abs(pickle_filename)
     # If |data| is same with the file content, we skip updating.
     if os.path.isfile(pickle_filename):
-        with open(pickle_filename) as pickle_file:
+        with open(pickle_filename, 'rb') as pickle_file:
             try:
                 if pickle.load(pickle_file) == data:
                     return
