# $NetBSD$
#
#	definitions needed for Jabber transports and services
#
.if  !defined(JABBER_TRANSPORTS_MK)
# multiple inclusion suppression
JABBER_TRANSPORTS_MK=	defined

BUILD_DEFS+=		JABBER_USER JABBER_GROUP JABBER_LOGDIR
BUILD_DEFS+=		JABBER_PIDDIR JABBER_SPOOLDIR JABBER_TRANSDIR
BUILD_DEFS+=		JABBER_EXDIR
PKG_SYSCONFSUBDIR=	jabberd

JABBER_USER?=		jabberd
JABBER_GROUP?=		jabberd
JABBER_PIDDIR?=	/var/run/jabberd
JABBER_LOGDIR?=	/var/log/jabberd
JABBER_SPOOLDIR?=	/var/spool/jabberd
JABBER_TRANSDIR?=	libexec/jabber-transports
JABBER_EXDIR?=		share/examples/jabber

OWN_DIRS+=		${JABBER_PIDDIR}
OWN_DIRS+=		${JABBER_LOGDIR}
OWN_DIRS+=		${JABBER_SPOOLDIR}

FILES_SUBST+=		JABBER_USER=${JABBER_USER:Q}
FILES_SUBST+=		JABBER_GROUP=${JABBER_GROUP:Q}
FILES_SUBST+=		JABBER_PIDDIR=${JABBER_PIDDIR:Q}
FILES_SUBST+=		JABBER_LOGDIR=${JABBER_LOGDIR:Q}
FILES_SUBST+=		JABBER_SPOOLDIR=${JABBER_SPOOLDIR:Q}
FILES_SUBST+=		JABBER_TRANSDIR=${JABBER_TRANSDIR:Q}

PLIST_SUBST+=		JABBER_TRANSDIR=${JABBER_TRANSDIR:Q}
PLIST_SUBST+=		JABBER_EXDIR=${JABBER_EXDIR:Q}

PKG_GROUPS+=		${JABBER_GROUP}
PKG_USERS+=		${JABBER_USER}:${JABBER_GROUP}

EGDIR=		${PREFIX}/${JABBER_EXDIR}
.endif	# JABBER_TRANSPORTS_MK
