$NetBSD$

(1) put  homepage link
(2) add shiftdir tweek to support main program (mop) and
    files in share directory shift
-- These have been communicated with original author.

--- mop.rb.orig	2007-02-17 07:55:25.000000000 +0900
+++ mop.rb	2011-10-19 17:33:58.000000000 +0900
@@ -61,6 +61,12 @@
 	  links.join(" | "))
 end
 
+def homepage()
+  sprintf("<div class=\"c pre small\" id=\"homepage\">\n%s\n</div>",
+          tagify("a", {"href"=>"http://www.gentei.org/~yuuji/software/mop/", "id"=>"homepage"}, "generated by MoP") )
+end
+
+
 def escape(string)
   string.gsub(/([\"'<>{}])/n) do
       '&#x' + $1.unpack('H2').join('').upcase + ';'
@@ -155,13 +161,14 @@
 
 def init(dir, cmd="ln -s")
   mydir=chasemydir
+  shiftdir='../share/mop'; # shift from bin location to share
   for file in %w(basic.css mop.css mop.js q.png ans.png don.png taro-l.png
 		 hanako-r.png)
     f = File.join(dir, file)
-    test(?r, f) || system("#{cmd} #{File.join(mydir, file)} #{f}")
+    test(?r, f) || system("#{cmd} #{File.join(mydir, shiftdir, file)} #{f}")
   end
   for file in %(template.html)
-    system("cp #{File.join(mydir, file)} #{dir}")
+    system("cp #{File.join(mydir, shiftdir, file)} #{dir}")
   end
   exit 0
 end
@@ -265,7 +272,7 @@
     bottom = tagify("div", {"id"=>"_bottom"}, ".", false);
     hr = href($base, $count, total)
     s1 = tagify("div", {"class" => "s1"}, filter(rest), true)
-    slide.puts tagify("div", {"class" => "s0"}, s1+hr+bottom, true)
+    slide.puts tagify("div", {"class" => "s0"}, s1+hr+homepage()+bottom, true)
 #slide.puts hr+bottom;
     slide.puts "</body>\n"
     slide.puts "</html>\n"
