set(ARCH_DEFINES -D_NETBSD -DTARGET_POSIX -DTARGET_NETBSD)
set(SYSTEM_DEFINES)
set(PLATFORM_DIR linux)
set(CMAKE_SYSTEM_NAME NetBSD)
if(WITH_ARCH)
  set(ARCH ${WITH_ARCH})
else()
  if(CPU STREQUAL x86_64)
    set(ARCH x86_64-netbsd)
    set(NEON False)
  elseif(CPU MATCHES "i386")
    set(ARCH i486-netbsd)
    set(NEON False)
    add_options(CXX ALL_BUILDS "-msse")
  elseif(CPU MATCHES arm) # XXX non-neon
    set(ARCH arm)
    set(NEON True)
    set(NEON_FLAGS "-mfpu=neon -mvectorize-with-neon-quad")
  else()
    message(SEND_ERROR "Unknown CPU: ${CPU}")
  endif()
endif()

# Make sure we strip binaries in Release build
if(CMAKE_BUILD_TYPE STREQUAL Release AND CMAKE_COMPILER_IS_GNUCXX)
  set(CMAKE_CXX_FLAGS_RELEASE "${CMAKE_CXX_FLAGS_RELEASE} -s")
endif()

find_package(CXX11 REQUIRED)
