$NetBSD$

From 035c305ce7761f51328b45f1bd83e26aef267c9d Mon Sep 17 00:00:00 2001
From: Frank Tang <ftang@chromium.org>
Date: Thu, 15 Oct 2020 22:44:27 -0700
Subject: [PATCH] [Intl] call new ListFormatter::createInstance

The one we currently using is now marked as internal and to be removed
for 68. Migrating to the style which already avaiable in ICU 67-1.

Bug: v8:11031
Change-Id: I668382a2e1b8602ddca02bf231c5008a6c92bf2d
Reviewed-on: https://chromium-review.googlesource.com/c/v8/v8/+/2477751
Reviewed-by: Jakob Kummerow <jkummerow@chromium.org>
Commit-Queue: Frank Tang <ftang@chromium.org>
Cr-Commit-Position: refs/heads/master@{#70638}
---
 src/objects/js-list-format.cc | 55 ++++++++++++-----------------------
 1 file changed, 18 insertions(+), 37 deletions(-)

diff --git a/src/objects/js-list-format.cc b/src/objects/js-list-format.cc
index b17d38c43ff5..e48a387be50f 100644
--- src/3rdparty/chromium/v8/src/objects/js-list-format.cc.orig
+++ src/3rdparty/chromium/v8/src/objects/js-list-format.cc
@@ -29,46 +29,27 @@ namespace v8 {
 namespace internal {
 
 namespace {
-const char* kStandard = "standard";
-const char* kOr = "or";
-const char* kUnit = "unit";
-const char* kStandardShort = "standard-short";
-const char* kOrShort = "or-short";
-const char* kUnitShort = "unit-short";
-const char* kStandardNarrow = "standard-narrow";
-const char* kOrNarrow = "or-narrow";
-const char* kUnitNarrow = "unit-narrow";
-
-const char* GetIcuStyleString(JSListFormat::Style style,
-                              JSListFormat::Type type) {
+
+UListFormatterWidth GetIcuWidth(JSListFormat::Style style) {
+  switch (style) {
+    case JSListFormat::Style::LONG:
+      return ULISTFMT_WIDTH_WIDE;
+    case JSListFormat::Style::SHORT:
+      return ULISTFMT_WIDTH_SHORT;
+    case JSListFormat::Style::NARROW:
+      return ULISTFMT_WIDTH_NARROW;
+  }
+  UNREACHABLE();
+}
+
+UListFormatterType GetIcuType(JSListFormat::Type type) {
   switch (type) {
     case JSListFormat::Type::CONJUNCTION:
-      switch (style) {
-        case JSListFormat::Style::LONG:
-          return kStandard;
-        case JSListFormat::Style::SHORT:
-          return kStandardShort;
-        case JSListFormat::Style::NARROW:
-          return kStandardNarrow;
-      }
+      return ULISTFMT_TYPE_AND;
     case JSListFormat::Type::DISJUNCTION:
-      switch (style) {
-        case JSListFormat::Style::LONG:
-          return kOr;
-        case JSListFormat::Style::SHORT:
-          return kOrShort;
-        case JSListFormat::Style::NARROW:
-          return kOrNarrow;
-      }
+      return ULISTFMT_TYPE_OR;
     case JSListFormat::Type::UNIT:
-      switch (style) {
-        case JSListFormat::Style::LONG:
-          return kUnit;
-        case JSListFormat::Style::SHORT:
-          return kUnitShort;
-        case JSListFormat::Style::NARROW:
-          return kUnitNarrow;
-      }
+      return ULISTFMT_TYPE_UNITS;
   }
   UNREACHABLE();
 }
@@ -143,7 +124,7 @@ MaybeHandle<JSListFormat> JSListFormat::New(Isolate* isolate, Handle<Map> map,
   icu::Locale icu_locale = r.icu_locale;
   UErrorCode status = U_ZERO_ERROR;
   icu::ListFormatter* formatter = icu::ListFormatter::createInstance(
-      icu_locale, GetIcuStyleString(style_enum, type_enum), status);
+      icu_locale, GetIcuType(type_enum), GetIcuWidth(style_enum), status);
   if (U_FAILURE(status) || formatter == nullptr) {
     delete formatter;
     THROW_NEW_ERROR(isolate, NewRangeError(MessageTemplate::kIcuError),
