$NetBSD$

Use index_modules() instead of pickup up modules in ${PWD} (and mostly likely
failing).

Patch shared upstream via:

 <https://github.com/threat9/routersploit/pull/578>

--- routersploit/core/exploit/payloads.py.orig	2018-10-17 17:30:53.000000000 +0000
+++ routersploit/core/exploit/payloads.py
@@ -1,4 +1,3 @@
-import os
 import importlib
 from collections import namedtuple
 from struct import pack
@@ -22,6 +21,7 @@ from routersploit.core.exploit.printer i
 )
 
 from routersploit.core.exploit.utils import (
+    index_modules,
     random_text,
 )
 
@@ -122,25 +122,19 @@ class BasePayload(BaseExploit):
         raise NotImplementedError()
 
     def get_encoders(self):
-        path = "routersploit/modules/encoders/{}".format(self.architecture)
-
         encoders = []
 
-        try:
-            files = os.listdir(path)
-        except FileNotFoundError:
-            return []
-
-        for f in files:
-            if not f.startswith("__") and f.endswith(".py"):
-                encoder = f.replace(".py", "")
-                module_path = "{}/{}".format(path, encoder).replace("/", ".")
-                module = getattr(importlib.import_module(module_path), "Encoder")
-                encoders.append((
-                    "{}/{}".format(self.architecture, encoder),
-                    module._Encoder__info__["name"],
-                    module._Encoder__info__["description"],
-                ))
+        # get all encoders for given architecture
+        all_encoders = [e for e in index_modules() if "encoders.{}".format(self.architecture) in e]
+
+        for e in all_encoders:
+            encoder = e.replace("encoders.{}.".format(self.architecture), "").replace(".", "/")
+            module = getattr(importlib.import_module('routersploit.modules.' + e), "Encoder")
+            encoders.append((
+                "{}/{}".format(self.architecture, encoder),
+                module._Encoder__info__["name"],
+                module._Encoder__info__["description"],
+            ))
 
         return encoders
 
